VERSION 5.00
Begin VB.UserControl vcGame 
   BackColor       =   &H00404040&
   ClientHeight    =   3030
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2895
   InvisibleAtRuntime=   -1  'True
   Picture         =   "vcGame.ctx":0000
   ScaleHeight     =   202
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   193
   ToolboxBitmap   =   "vcGame.ctx":0C42
End
Attribute VB_Name = "vcGame"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Private isBound As Boolean      ' Are we hooked to the game
Private vc_hWnd As Long         ' Voodoo Chat window handle

Public Event ReceiveData(ByVal fromUser As String, ByVal Data As String)    ' Called whenever data is received
Public Event Error(ByVal Desc As String)                                    ' Used to display error information

' Hook the control to game in order to receive Voodoo data
Public Function hookHWND(ByVal ghWnd As Long, ByVal vhWnd As Long) As Boolean
    If isBound = False Then
        FrmHwnd = ghWnd
        OldProc = GetWindowLong(FrmHwnd, GWL_WNDPROC)
        SetWindowLong FrmHwnd, GWL_WNDPROC, AddressOf WndProc
        vc_hWnd = vhWnd
        isBound = True
        hookHWND = True
    Else
        RaiseEvent Error("hookHWND() - Already hooked to game")
        hookHWND = False
    End If
End Function

' Make the control a pretty square in design mode
Private Sub UserControl_Initialize()
    WM_VOODOO = RegisterWindowMessage("WM_VOODOO")
    Set tmpGame = Me
    UserControl.Width = 32 * Screen.TwipsPerPixelX
    UserControl.Height = 32 * Screen.TwipsPerPixelY
End Sub

' Make the control a pretty square in design mode
Private Sub UserControl_Resize()
    UserControl.Width = 32 * Screen.TwipsPerPixelX
    UserControl.Height = 32 * Screen.TwipsPerPixelY
End Sub

' Release hook to game and terminate
Private Sub UserControl_Terminate()
    Set tmpGame = Nothing
    If isBound = True Then
        SetWindowLong FrmHwnd, GWL_WNDPROC, OldProc
    End If
End Sub

' Arriving data from Voodoo
Public Sub gotData(ByVal Data As String)
    Dim Str() As String
    Str = Split(Data, Chr(255), 2)
    RaiseEvent ReceiveData(Str(0), Str(1))
End Sub

' Sends raw data to Voodoo
Public Function SendData(ByVal Data As String) As Boolean
    Dim Atom As Integer
    
    If isBound = False Then SendData = False: RaiseEvent Error("SendData() - Component not hooked to game"):  Exit Function
    If Len(Data) > 255 Then SendData = False: RaiseEvent Error("SendData() - Max packet size is 255 bytes"): Exit Function
    Atom = GlobalAddAtom(Data)
    PostMessage vc_hWnd, RegisterWindowMessage("WM_VOODOO"), CLng(Atom), &H0
    SendData = True
End Function

' Public variable to determine if hooked or not
Public Property Get var_isBound() As Boolean
    var_isBound = isBound
End Property
